<?php
/**
 * Plugin Name: What Time Is It Clock
 * Plugin URI: https://www.renatocantarella.it/plugin-wordpress-what-time-is-it/
 * Description: Display a smooth digital clock in the WordPress editor sidebar, with time zone selection.
 * Author URI: https://renatocantarella.it/
 * Version: 1.0
 * Author: Renato Cantarella
 * Text Domain: what-time-is-it
 * Domain Path: /languages
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Version: 6.0.6
 * Requires at least: 6.6
 * Requires PHP: 7.4
 */

function wtii_add_meta_box() {
    add_meta_box(
        'wtii_box',
        __('What Time Is It', 'what-time-is-it'),
        'wtii_render_box',
        ['post', 'page'],
        'side',
        'high'
    );
}
add_action('add_meta_boxes', 'wtii_add_meta_box');

function wtii_render_box() {
    $timezone = get_user_meta(get_current_user_id(), '_wtii_timezone', true);
    if (!$timezone) $timezone = 'Europe/Rome';
    $zones = timezone_identifiers_list();

    echo '<div id="orologio-box">';
    echo '<div class="orologio-header">🕒 <span>' . esc_html__('Ora esatta', 'what-time-is-it') . '</span> (<span id="current-tz">' . esc_html($timezone) . '</span>)</div>';
    echo '<div id="clock">--:--:--</div>';
    echo '<input list="timezones" id="timezoneInput" placeholder="' . esc_attr__('Cambia fuso orario', 'what-time-is-it') . '">';
    echo '<datalist id="timezones">';
    foreach ($zones as $zone) {
        echo '<option value="' . esc_attr($zone) . '">' . esc_html($zone) . '</option>';
    }
    echo '</datalist></div>';
    echo '<script>const initialTimezone = ' . json_encode($timezone) . ';</script>';
}

add_action('admin_enqueue_scripts', function($hook) {
    if ($hook !== 'post.php' && $hook !== 'post-new.php') return;
    $plugin_version = '1.0';
    wp_enqueue_script('wtii-clock', plugin_dir_url(__FILE__) . 'js/clock.js', [], $plugin_version, true);
    wp_enqueue_style('wtii-style', plugin_dir_url(__FILE__) . 'css/clock.css', [], $plugin_version);
    wp_localize_script('wtii-clock', 'OrologioAjax', [
        'ajax_url' => admin_url('admin-ajax.php'),
        'nonce'    => wp_create_nonce('wtii_nonce'),
    ]);
});

add_action('wp_ajax_orologio_save_timezone', function() {
    check_ajax_referer('wtii_nonce');
    if (isset($_POST['timezone'])) {
        update_user_meta(get_current_user_id(), '_wtii_timezone', sanitize_text_field(wp_unslash($_POST['timezone'])));
        wp_send_json_success();
    }
    wp_send_json_error();
});
