document.addEventListener("DOMContentLoaded", function () {
    const clock = document.getElementById("clock");
    const tzInput = document.getElementById("timezoneInput");
    const tzLabel = document.getElementById("current-tz");

    let interval = null;
    let currentTimezone = initialTimezone;

    function startClock(timezone) {
        if (interval) clearInterval(interval);
        function render() {
            const opzioni = {
                timeZone: timezone,
                hour12: false,
                hour: "2-digit",
                minute: "2-digit",
                second: "2-digit"
            };
            try {
                const ora = new Date().toLocaleTimeString("it-IT", opzioni);
                clock.textContent = ora;
            } catch (e) {
                clock.textContent = "Errore orario";
            }
        }
        render();
        interval = setInterval(render, 1000);
    }

    function normalizeTimezone(input) {
        const tz = input.trim().replace(/\s+/g, "_");
        const capitalized = tz
            .split("/")
            .map(part => part.charAt(0).toUpperCase() + part.slice(1).toLowerCase())
            .join("/");
        return capitalized;
    }

    startClock(currentTimezone);

    tzInput.addEventListener("change", () => {
        const tz = normalizeTimezone(tzInput.value);
        try {
            startClock(tz);
            currentTimezone = tz;
            tzLabel.textContent = tz;
            fetch(OrologioAjax.ajax_url, {
                method: "POST",
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: "action=orologio_save_timezone&timezone=" + encodeURIComponent(tz) + "&_ajax_nonce=" + OrologioAjax.nonce
            });
        } catch (e) {
            console.warn("Timezone non valida, uso precedente:", currentTimezone);
            startClock(currentTimezone);
        }
    });
});
